# Guide de déploiement sécurisé - KOMBAR FERD

## ⚠️ AVANT DE DÉPLOYER EN PRODUCTION

### 1. Configuration des variables d'environnement

1. **Copiez le fichier d'exemple :**
   ```bash
   cp .env.example .env
   ```

2. **Modifiez `.env` avec vos valeurs de production :**
   ```bash
   # Base de données
   DB_HOST=votre-serveur-db
   DB_NAME=votre-base-de-donnees
   DB_USER=votre-utilisateur-db
   DB_PASS=votre-mot-de-passe-super-fort
   
   # Sécurité - GÉNÉREZ DES CLÉS FORTES !
   JWT_SECRET=utilisez-un-generateur-de-cle-aleatoire-64-caracteres-minimum
   APP_ENV=production
   ```

3. **Sécurisez le fichier .env :**
   ```bash
   chmod 600 .env  # Lecture seule par le propriétaire
   chown www-data:www-data .env  # Si Apache/Nginx
   ```

### 2. Migration des mots de passe

**⚠️ CRITIQUE :** Avant la première utilisation, migrez les mots de passe :

```bash
php migrate_passwords.php
```

**Vérifiez que la migration a fonctionné :**
- Tous les utilisateurs doivent pouvoir se connecter
- Les mots de passe en base sont maintenant hashés (60 caractères)

### 3. Vérifications de sécurité

✅ **Checklist de sécurité :**

- [ ] `.env` n'est PAS commité dans Git
- [ ] `.gitignore` contient `.env`
- [ ] Mots de passe migrés vers bcrypt
- [ ] JWT_SECRET généré de manière aléatoire
- [ ] APP_ENV=production en production
- [ ] Permissions fichiers correctes (600 pour .env)
- [ ] Credentials DB changés par rapport aux valeurs par défaut

### 4. Variables d'environnement serveur

Sur un serveur de production, vous pouvez aussi définir les variables directement :

**Apache (.htaccess) :**
```apache
SetEnv DB_HOST "votre-host"
SetEnv DB_NAME "votre-db"
SetEnv JWT_SECRET "votre-secret"
```

**Nginx (fastcgi_params) :**
```nginx
fastcgi_param DB_HOST "votre-host";
fastcgi_param DB_NAME "votre-db";
fastcgi_param JWT_SECRET "votre-secret";
```

**Système (variables d'environnement) :**
```bash
export DB_HOST="votre-host"
export JWT_SECRET="votre-secret"
```

### 5. Génération de JWT_SECRET sécurisé

Utilisez l'une de ces méthodes :

```bash
# Option 1: OpenSSL
openssl rand -base64 64

# Option 2: PHP
php -r "echo base64_encode(random_bytes(64));"

# Option 3: Online (utilisez un générateur réputé)
# https://generate-random.org/api-key-generator?count=1&length=64&type=mixed-numbers
```

### 6. Test après déploiement

1. **Testez la configuration :**
   ```bash
   php test_env_config.php
   ```

2. **Testez l'authentification :**
   ```bash
   curl -X POST your-domain.com/pesees-api/auth \
   -H "Content-Type: application/json" \
   -d '{"action":"login","username":"ADMIN","password":"ADMIN2024"}'
   ```

### 7. Monitoring et logs

- Surveillez les logs d'erreur : `logs/error.log`
- Vérifiez les tentatives de connexion échouées
- Activez la rotation des logs

## 🚨 EN CAS DE COMPROMISSION

Si vos credentials sont compromis :

1. **Changez immédiatement :**
   - JWT_SECRET dans .env
   - Mot de passe base de données
   - Mots de passe utilisateurs

2. **Révéquez toutes les sessions :**
   ```sql
   UPDATE user SET token = NULL;
   ```

3. **Vérifiez les logs d'accès**

## 📱 Contact

En cas de problème de sécurité, contactez l'administrateur système immédiatement.